begin
    a=addfile("/home/sharedata/csr4/zhangyue/geo/S/s_0.05_0.12_10.nc","r")
    S=a->s1
    printVarSummary(S)
    S=S*0.5
    S_month=reshape(S, (/20,12,3600,7200/))
    copy_VarMeta(S(0,:,:), S_month(0,0,:,:))
    printVarSummary(S_month)

    S_Mar = S_month(:,2,:,:)
    S_Jul = S_month(:,6,:,:)
    S_Mar_draw = dim_avg_n_Wrap(S_Mar, 0)
    S_Jul_draw = dim_avg_n_Wrap(S_Jul, 0)
    S_difference_draw = S_Mar_draw - S_Jul_draw
    copy_VarMeta(S_Mar_draw, S_difference_draw)

    setvalues  NhlGetWorkspaceObjectId()
    "wsMaximumSize":10000000000
    end setvalues

    wks=gsn_open_wks("png", "S_Mar")
    res=True
    res@gsnFrame=False
    res@gsnDraw = False
    res@cnFillOn=True
    res@cnFillPalette="WhiteYellowOrangeRed";"MPL_summer"

    ;The setting for S in March.
    res@cnLevelSelectionMode ="ExplicitLevels"
    res@cnLevels=(/0.01,0.1,0.2,0.3,0.35,0.4,0.45/)

    ;The draw setting for the difference between S in March and July
    ;res@cnFillPalette="temp_diff_18lev";"nrl_sirkes";"BlueDarkRed18"
    ;res@cnLevelSelectionMode ="ExplicitLevels" 
    ;res@cnLevels = (/-0.2,-0.15,-0.1,-0.05,-0.02,-0.01,0.01,0.02,0.05,0.1,0.15,0.2/)


    res@cnLinesOn=False
    res@gsnAddCyclic=False
    res@mpGeophysicalLineThicknessF =2.0

    res@tmXBLabelFontHeightF=0.018
    res@tmYLLabelFontHeightF=0.018
    res@tmBorderThicknessF=4
    ;res@lbLabelFontHeightF=0.025
    res@lbBoxSeparatorLinesOn=False
    res@tmXTOn=False
    res@tmYROn=False
    res@pmLabelBarHeightF=0.1
    res@pmLabelBarOrthogonalPosF=0.2
    res@gsnMaximize=True

    res@mpDataSetName  = "/home/data/data-CSR4/chenyu/mapdata/Earth..4"
    res@mpDataBaseVersion="MediumRes"
    res@mpLimitMode       = "Corners"         ; choose range of map
    res@mpLeftCornerLatF  = 25.2; 28;lat2d(5,5)
    res@mpLeftCornerLonF  = 78; 88;lon2d(5,5)
    res@mpRightCornerLatF = 51;lat2d(nlat-3,nlon-1)
    res@mpRightCornerLonF = 146; 134;lon2d(nlat-3,nlon-1)  

    res@mpProjection          ="LambertConformal"
    res@mpLambertParallel1F    = 30.
    res@mpLambertParallel2F    = 60.
    res@mpLambertMeridianF     = 102. 
       
    res@mpGridAndLimbOn = True 
    res@mpGridLatSpacingF = 5
    res@mpGridLonSpacingF = 5
    res@mpGridLineDashPattern = 0
    res@mpGridLineThicknessF=2.
    res@mpGridLineColor = "grey"   
    res@pmTickMarkDisplayMode  = "Always"
    ;res@pmLabelBarOrthogonalPosF = 0.2
    res@pmLabelBarOrthogonalPosF=0.05  
    res@mpLandFillColor="white"
    ;res@pmLabelBarWidthF = 0.9
    ;res@pmLabelBarHeightF=0.3
    res@lbLabelFontHeightF=0.015; 0.02;
    res@tmXBLabelFontHeightF=0.02
    res@tmYLLabelFontHeightF=0.02


    plot=gsn_csm_contour_map(wks,S_Mar_draw,res) ; Fig 3b change to S_difference_draw

    shp1="/home/csr4/chenyu/NCL/china/mygeodata/china.shp"
    lnres1        = True
    lnres1@gsLineColor      ="black"
    lnres1@gsLineThicknessF = 3           ; 2x thickness
    shp_plot1     = gsn_add_shapefile_polylines(wks,plot,shp1,lnres1)


  laty=(/36,43,43,36,36/)
  lonx=(/78,78,94,94,78/)

  resa=True
  resa@gsLineColor = "blue4"
  resa@gsLineThicknessF=4.
  dra=gsn_add_polyline(wks, plot, lonx, laty, resa)

  laty1=(/38,46,46,38,38/)
  lonx1=(/96,96,110,110,96/)
  resb=True
  resb@gsLineColor = "blue4"
  resb@gsLineThicknessF=4.
  fig=gsn_add_polyline(wks, plot, lonx1, laty1, resb)

draw(plot)
frame(wks)

end

;This main code shows how to calculate the Monthly and Annual s for TD and GD. This is the data basic for Fig 3c-f. Then the data is then visualized based on origin
begin
    a=addfile("/home/sharedata/csr4/zhangyue/geo/S/s_0.05_0.17_15.nc","r")
    S=a->s1
    printVarSummary(S)
    S=S*0.5
    S_month=reshape(S, (/20,12,3600,7200/))
    copy_VarMeta(S(0,:,:), S_month(0,0,:,:))
    printVarSummary(S_month)

    S_TD = S_month(:,:,{36:43},{78:94})
    S_GD = S_month(:,:,{38:46},{96:110})

    S_TD_mon_1 = dim_avg_n(S_TD, (/2,3/))
    S_TD_mon_2 = dim_avg_n(S_TD_mon_1, 0)
    print(S_TD_mon_2)

    S_GD_mon_1 = dim_avg_n(S_GD, (/2,3/))
    S_GD_mon_2 = dim_avg_n(S_GD_mon_1, 0)
    print(S_GD_mon_2)

    S_TD_year = dim_avg_n(S_TD, (/1,2,3/))
    s_GD_year = dim_avg_n(S_GD, (/1,2,3/))
    print(S_TD_year)
    print(s_GD_year)
 
end